//	TorusGamesKeyboardView.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <UIKit/UIKit.h>
#import "GeometryGames-Common.h"	//	for Char16

#define KEYINSET_H	2.0
#define KEYINSET_V	2.0

#define MAX_ROWS	 3
#define MAX_COLUMNS	11


@protocol TorusGamesKeyboardViewDelegate
- (void)userTappedKey:(unichar)aCharacter;
@end


@interface TorusGamesKeyboardView : UIView <UITextFieldDelegate>

- (id)initWithDelegate:(id<TorusGamesKeyboardViewDelegate>)aDelegate frame:(CGRect)aFrame;
- (void)refreshWithLanguage:(const Char16 [3])aTwoLetterLanguageCode;

//	UITextField notification
- (void)characterReceiverTextDidChange:(id)sender;

//	UITextFieldDelegate
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (void)textFieldDidEndEditing:(UITextField *)textField;
- (BOOL)textFieldShouldReturn:(UITextField *)textField;

@end
